
// This file contains sound and music notes.
//
// Each sound begins with the note length in video frames per note. To
// convert a tempo from beats per minute, use the following formula:
//
//   FramesPerNote = 50 / (BeatsPerMinute / 60)
//
// The result might not be an integer, so round up or down it as appropriate.
// It may not exceed 255 (which is about 11.75 beats per minute) because the
// FramesPerNote field of a tySound structure, where it gets copied to, is
// only 8 bits wide. It must also be larger than 1 (3000 beats per minute).
//
// The last note in the sound is either ENDSOUND, which stops the sound, or
// LOOPSOUND, which restarts it from the beginning.
	
const u16 bananastreble[] = {
   10,
   C_5, HOLD, HOLD, G_4, A_4, G_4, HOLD, F_4, E_4, G_4, HOLD, HOLD, HOLD, HOLD, HOLD, G_5, A_5, C_6, HOLD, B_5, A_5, G_5, HOLD, B_5, C_6, HOLD, C_5, HOLD, C_4, HOLD, ENDSOUND,};

const u16 bananasbass[] = {
   10,
   C_3, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, G_3, HOLD, F_3, HOLD, E_3, HOLD, D_3, HOLD, HOLD, HOLD, G_3, HOLD, HOLD, HOLD, C_3, HOLD, HOLD, HOLD, HOLD, HOLD, ENDSOUND,};

const u16 titlescreen[] = {
   10,   
   C_5, HOLD, C_5, HOLD, B_4, HOLD, C_5, D_5, HOLD, HOLD, HOLD, HOLD, C_5, HOLD, B_4, C_5, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, G_4, C_5, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD,
   C_5, HOLD, C_5, HOLD, B_4, HOLD, C_5, D_5, HOLD, HOLD, HOLD, HOLD, C_5, HOLD, B_4, C_5, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, B_4, C_5, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD,
   B_4, HOLD, A_4, HOLD, B_4, HOLD, A_4, G_4, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, B_4, E_5, C_5, HOLD, D_5, HOLD, C_5, HOLD, B_4, C_5, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, 

   C_5, HOLD, C_5, HOLD, B_4, HOLD, C_5, D_5, HOLD, HOLD, HOLD, HOLD, C_5, HOLD, B_4, C_5, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, G_4, C_5, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD,
   E_5, HOLD, E_5, HOLD, D_5, HOLD, E_5, F_5, HOLD, HOLD, HOLD, HOLD, E_5, HOLD, D_5, E_5, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, DS5, E_5, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD,
   F_5, HOLD, F_5, HOLD, G_5, HOLD, G_5, A_5, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, G_5, B_5, G_5, HOLD, F_5, HOLD, E_5, HOLD, G_5, C_5, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD,  
 
   C_5, HOLD, C_5, HOLD, B_4, HOLD, C_5, D_5, HOLD, HOLD, HOLD, HOLD, C_5, HOLD, B_4, C_5, HOLD, HOLD, C_6, HOLD, B_5, HOLD, C_6, HOLD, D_6, HOLD, C_6, HOLD, B_5, HOLD, D_6, HOLD, 
   C_5, HOLD, C_5, HOLD, B_4, HOLD, C_5, D_5, HOLD, HOLD, HOLD, HOLD, C_5, HOLD, B_4, C_5, HOLD, HOLD, C_6, HOLD, D_6, HOLD, E_6, HOLD, C_6, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD,  
   B_4, HOLD, A_4, HOLD, B_4, HOLD, A_4, G_4, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, B_4, E_5, C_5, HOLD, D_5, HOLD, C_5, HOLD, B_4, C_5, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD, HOLD,     
LOOPSOUND,};

const u16 titlescreen2[] = {
   10,
   C_3, HOLD, G_3, HOLD, G_2, HOLD, G_3, HOLD, D_3, HOLD, G_3, HOLD, G_2, HOLD, G_3, HOLD, C_3, HOLD, G_3, HOLD, G_2, HOLD, G_3, HOLD, C_3, HOLD, G_3, HOLD, G_2, HOLD, G_3, HOLD, 
   C_3, HOLD, G_3, HOLD, G_2, HOLD, G_3, HOLD, D_3, HOLD, G_3, HOLD, G_2, HOLD, G_3, HOLD, C_3, HOLD, G_3, HOLD, G_2, HOLD, G_3, HOLD, C_3, HOLD, G_3, HOLD, G_2, HOLD, G_3, HOLD, 
   B_2, HOLD, G_3, HOLD, G_2, HOLD, G_3, HOLD, D_3, HOLD, G_3, HOLD, G_2, HOLD, G_3, HOLD, C_3, HOLD, G_3, HOLD, E_3, HOLD, G_3, HOLD, C_3, HOLD, G_2, HOLD, A_2, HOLD, B_2, HOLD,
LOOPSOUND,};

const u16 spinsound[] = {
   6,
   E_5,DS5,D_5,CS5,C_5,CS5,D_5,DS5,LOOPSOUND,};

const u16 losesound[] = {
   15,
   E_5,DS5,D_5,DS5,G_4,ENDSOUND,};

const u16 winsound[] = {
   15,
   C_4,E_4,G_4,B_4,C_5,G_4,C_5,ENDSOUND,};
  
const u16 losesoundslow[] = {
   10,
   E_5,DS5,D_5,DS5,G_4,ENDSOUND,};

const u16 winsoundslow[] = {
   10,
   C_4,E_4,G_4,B_4,C_5,G_4,C_5,ENDSOUND,};

const u16 losesoundslow2[] = {
   75,
   E_4,DS4,D_4,DS4,G_3,ENDSOUND,};

const u16 winsoundslow2[] = {
   57,
   C_4,E_4,G_4,B_4,C_5,G_4,C_5,ENDSOUND,};

const u16 losesoundkindofslow[] = {
   7,
   E_5,DS5,D_5,DS5,G_4,ENDSOUND,};

const u16 winsoundkindofslow[] = {
   7,
   C_4,E_4,G_4,B_4,C_5,G_4,C_5,ENDSOUND,};




const u16 silence[] = {
	1,
	C_0,ENDSOUND,};

